<?php
session_start();
require_once __DIR__ . '/../../includes/db.php';
$config = require __DIR__ . '/../../includes/config.php';
$base   = rtrim($config['base_url'], '/');

// hanya admin
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'admin') {
    header("Location: {$base}/login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bookingId = (int)($_POST['booking_id'] ?? 0);
    $meetLink  = trim($_POST['meet_link'] ?? '');

    if ($bookingId <= 0) {
        $_SESSION['flash_meet'] = 'Booking tidak valid.';
        header("Location: {$base}/admin/index.php");
        exit;
    }

    $stmt = $pdo->prepare("UPDATE bookings SET meet_link = ? WHERE id = ?");
    $stmt->execute([$meetLink, $bookingId]);

    $_SESSION['flash_meet'] = 'Link Meet berhasil disimpan.';
    header("Location: {$base}/admin/index.php");
    exit;
}
