<?php
require_once __DIR__.'/../includes/db.php';
header('Content-Type: application/json');

$booking_id = (int)($_GET['booking_id'] ?? 0);
if ($booking_id <= 0) {
    echo json_encode(['error' => 'invalid']); exit;
}

$stmt = $pdo->prepare("
    SELECT status, chat_status, video_status
    FROM bookings
    WHERE id = ?
");
$stmt->execute([$booking_id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    echo json_encode(['error' => 'not_found']); exit;
}

echo json_encode([
    'status'      => $row['status'],
    'chat_status' => $row['chat_status'],
    'video_status'=> $row['video_status'],
]);
