<?php
session_start();
require __DIR__ . '/../includes/db.php';

$booking_id = (int)($_GET['booking_id'] ?? 0);
$user_id    = (int)($_SESSION['user_id'] ?? 0);

header('Content-Type: application/json');

if ($booking_id <= 0 || $user_id <= 0) {
    echo json_encode(['ok' => false]);
    exit;
}

$stmt = $pdo->prepare("
    SELECT status
    FROM bookings
    WHERE id = ? AND user_id = ?
");
$stmt->execute([$booking_id, $user_id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    echo json_encode(['ok' => false]);
} else {
    echo json_encode([
        'ok'     => true,
        'status' => $row['status'],
    ]);
}
