<?php
require_once __DIR__ . '/../../includes/db.php';
$config = require __DIR__ . '/../../includes/config.php';
$base   = rtrim($config['base_url'], '/');

session_start();

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'psychologist') {
    header("Location: {$base}/login.php");
    exit;
}

$doctor_id  = (int)($_SESSION['doctor_id'] ?? 0);
$booking_id = (int)($_POST['booking_id'] ?? 0);

if ($doctor_id <= 0 || $booking_id <= 0) {
    header("Location: {$base}/doctor/index.php");
    exit;
}

// pastikan booking milik dokter
$stmt = $pdo->prepare("
    SELECT consultation_type, chat_status, video_status
    FROM bookings
    WHERE id = ? AND doctor_id = ?
");
$stmt->execute([$booking_id, $doctor_id]);
$bk = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$bk) {
    header("Location: {$base}/doctor/index.php");
    exit;
}

// 1) tandai chat sudah selesai
$pdo->prepare("
    UPDATE bookings
    SET chat_status = 'ended'
    WHERE id = ?
")->execute([$booking_id]);

// 2) tentukan apakah booking sudah boleh jadi done
$shouldDone = false;

if ($bk['consultation_type'] === 'chat') {
    // paket cuma chat
    $shouldDone = true;
} elseif ($bk['consultation_type'] === 'both'
      && $bk['video_status'] === 'ended') {
    // paket chat + video, video sudah beres, baru sekarang chat disetop
    $shouldDone = true;
}

if ($shouldDone) {
    $pdo->prepare("
        UPDATE bookings
        SET status = 'done'
        WHERE id = ?
    ")->execute([$booking_id]);
}

$_SESSION['flash_info'] = 'Sesi chat telah diakhiri oleh dokter.';
header("Location: {$base}/doctor/index.php");
exit;
