<?php
require_once __DIR__ . '/../../includes/db.php';
$config = require __DIR__ . '/../../includes/config.php';
$base   = rtrim($config['base_url'], '/');

session_start();

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'psychologist') {
    header("Location: {$base}/login.php");
    exit;
}

$doctor_id  = (int)($_SESSION['doctor_id'] ?? 0);
$booking_id = (int)($_POST['booking_id'] ?? 0);

if ($doctor_id <= 0 || $booking_id <= 0) {
    header("Location: {$base}/doctor/index.php");
    exit;
}

$stmt = $pdo->prepare("
    SELECT id FROM bookings
    WHERE id = ? AND doctor_id = ?
");
$stmt->execute([$booking_id, $doctor_id]);
if (!$stmt->fetch(PDO::FETCH_ASSOC)) {
    header("Location: {$base}/doctor/index.php");
    exit;
}
// 1) tandai video sudah selesai
$pdo->prepare("
    UPDATE bookings
    SET video_status = 'ended'
    WHERE id = ?
")->execute([$booking_id]);

// 2) cek apakah booking sudah boleh jadi done
$stmt2 = $pdo->prepare("
    SELECT consultation_type, chat_status, video_status
    FROM bookings
    WHERE id = ?
");
$stmt2->execute([$booking_id]);
$bk = $stmt2->fetch(PDO::FETCH_ASSOC);

$shouldDone = false;
if ($bk['consultation_type'] === 'video' && $bk['video_status'] === 'ended') {
    // paket cuma video
    $shouldDone = true;
} elseif ($bk['consultation_type'] === 'both'
      && $bk['chat_status'] === 'ended'
      && $bk['video_status'] === 'ended') {
    // paket chat + video, dua-duanya sudah selesai
    $shouldDone = true;
}

if ($shouldDone) {
    $pdo->prepare("
        UPDATE bookings
        SET status = 'done'
        WHERE id = ?
    ")->execute([$booking_id]);
}

$_SESSION['flash_info'] = 'Sesi konsultasi telah diakhiri oleh dokter.';
header("Location: {$base}/doctor/index.php");
exit;
