<?php
session_start();
require_once __DIR__ . '/../../includes/db.php';
$config = require __DIR__ . '/../../includes/config.php';
$base   = rtrim($config['base_url'], '/');

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'psychologist') {
    header("Location: {$base}/login.php");
    exit;
}

$doctorId  = (int)($_SESSION['doctor_id'] ?? 0);
$bookingId = (int)($_POST['booking_id'] ?? 0);

if ($doctorId <= 0 || $bookingId <= 0) {
    header("Location: {$base}/doctor/index.php");
    exit;
}

// pastikan booking milik dokter ini dan masih approved
$stmt = $pdo->prepare("
    SELECT id FROM bookings
    WHERE id = ? AND doctor_id = ? AND status = 'approved'
");
$stmt->execute([$bookingId, $doctorId]);
$bk = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$bk) {
    header("Location: {$base}/doctor/index.php");
    exit;
}

// tandai selesai
$upd = $pdo->prepare("
    UPDATE bookings
    SET status = 'done'
    WHERE id = ?
");
$upd->execute([$bookingId]);


$_SESSION['flash_success'] = 'Sesi konsultasi telah diakhiri.';
header("Location: {$base}/doctor/index.php");
exit;
