<?php
session_start();
date_default_timezone_set('Asia/Makassar');
require_once __DIR__.'/../../includes/db.php';
$config  = require __DIR__ . '/../../includes/config.php';
$base    = rtrim($config['base_url'], '/');

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'psychologist') {
    header("Location: {$base}/login.php");
    exit;
}

$doctorId   = (int)($_SESSION['doctor_id'] ?? 0);
$booking_id = (int)($_GET['booking_id'] ?? 0);
if ($booking_id <= 0 || $doctorId <= 0) {
    die('Akses ditolak');
}

$stmt = $pdo->prepare("
    SELECT *
    FROM bookings
    WHERE id = ?
      AND doctor_id = ?
      AND consultation_type IN ('video','both')
      AND status = 'approved'
");
$stmt->execute([$booking_id, $doctorId]);
$booking = $stmt->fetch(PDO::FETCH_ASSOC);


if (!$booking || !$booking['meet_link']) {
    die('Booking video call tidak ditemukan atau link Meet belum disiapkan');
}
$now             = new DateTime();
$scheduledAt     = new DateTime($booking['scheduled_at']);
$duration        = (int)($booking['duration_minutes'] ?? 60);
$sessionStartedAt = $booking['session_started_at'] ? new DateTime($booking['session_started_at']) : null;

// dokter boleh mulai 10 menit sebelum jadwal
$graceMinutes    = 2;
$canStartFrom    = (clone $scheduledAt)->modify("-{$graceMinutes} minutes");

$tooEarlyToStart = $now < $canStartFrom;
$expired         = $sessionStartedAt && $now > (clone $sessionStartedAt)->add(new DateInterval("PT{$duration}M"));

// endTime untuk timer pakai sessionStartedAt kalau sudah ada, kalau belum pakai scheduledAt
$baseStart = $sessionStartedAt ?: $scheduledAt;
$endTime   = (clone $baseStart)->add(new DateInterval("PT{$duration}M"));

// Dokter manual start (kalau mau dipakai)
// Dokter manual start
if (!$sessionStartedAt && !$tooEarlyToStart && isset($_GET['start_session'])) {
    $pdo->prepare("UPDATE bookings SET session_started_at=NOW() WHERE id=?")->execute([$booking_id]);
    header("Location: session_meet.php?booking_id=$booking_id");
    exit;
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Video Call Dokter - Booking #<?= (int)$booking_id ?></title>
    <meta charset="UTF-8">
    <style>
        body{font-family:Arial;max-width:500px;margin:50px auto;padding:20px;background:#f0f8ff;}
        .card{background:#fff;padding:30px;border-radius:15px;box-shadow:0 5px 15px rgba(0,0,0,0.1);text-align:center;}
        .btn{background:#4285f4;color:white;padding:15px 30px;text-decoration:none;border-radius:25px;
             font-size:16px;display:inline-block;box-shadow:0 3px 10px rgba(66,133,244,0.3);}
        .btn:hover{background:#3367d6;transform:translateY(-2px);}
        .btn-start{background:#34a853;color:white;}
        .timer{font-size:2em;color:#4285f4;font-weight:bold;margin:20px 0;}
        .status{color:#666;font-size:1.2em;}
    </style>
</head>
<body>
<div class="card">
    <h1>🏥 Sesi Video Call Dokter</h1>
    <h2>Pasien: Booking #<?= (int)$booking_id ?></h2>

    <?php if ($tooEarlyToStart): ?>
    <div class="status">⏳ Terlalu awal</div>
    <div class="timer">Jadwal: <?= $scheduledAt->format('H:i:s') ?></div>
    <p>Anda bisa mulai sesi maksimal <?= $graceMinutes; ?> menit sebelum jam ini.</p>

<?php elseif ($expired): ?>
    <div class="status">✅ Sesi Selesai</div>
    <div class="timer"><?= $duration ?> menit telah berlalu</div>
    <p>Sesi dengan pasien selesai. Terima kasih!</p>
    <a href="index.php" class="btn">← Dashboard Dokter</a>

<?php elseif (!$sessionStartedAt): ?>
    <div class="status">⏳ Belum mulai</div>
    <div class="timer">Jadwal: <?= $scheduledAt->format('H:i:s') ?></div>
    <p>Silakan klik "Mulai Sesi" untuk mulai hitung durasi dan mengaktifkan tombol Meet.</p>
    <a href="?booking_id=<?= $booking_id ?>&start_session=1" class="btn btn-start">🚀 Mulai Sesi</a>

<?php else: ?>
    <div class="status">▶️ Sesi Berlangsung</div>
    <div class="timer" id="timer">--:--</div>
    <p style="margin:20px 0;color:#666;">
        Durasi: <?= $duration ?> menit |
        Mulai: <?= $sessionStartedAt->format('H:i:s') ?>
    </p>

    <a href="<?= htmlspecialchars($booking['meet_link']) ?>"
       target="_blank" class="btn" id="meetBtn">
        🖥️ Buka Google Meet (sebagai Dokter)
    </a>

    <form method="post"
          action="<?= $base; ?>/doctor/end_session.php"
          style="margin-top:16px;">
        <input type="hidden" name="booking_id" value="<?= (int)$booking_id; ?>">
        <button type="submit" class="btn btn-start"
                onclick="return confirm('Akhiri sesi sekarang?')">
            ⏹ Akhiri Sesi
        </button>
    </form>

    <p style="margin-top:20px;font-size:0.9em;color:#888;">
        * Buka di tab baru. Jangan tutup halaman ini untuk melihat timer
    </p>
<?php endif; ?>


</div>

<?php if (!$expired && $sessionStartedAt): ?>
<script>
const endTimestamp = <?= $endTime->getTimestamp() ?> * 1000; // detik -> ms
const timerEl      = document.getElementById('timer');
const meetBtn      = document.getElementById('meetBtn');

function updateTimer() {
  const now = Date.now();
  let diff  = Math.floor((endTimestamp - now) / 1000); // sisa detik

  if (diff <= 0) {
    if (timerEl) {
      timerEl.textContent = '00:00';
      timerEl.style.color = '#ea4335';
    }
    if (meetBtn) meetBtn.remove();
    const status = document.querySelector('.status');
    if (status) status.textContent = '✅ Sesi Selesai';
    setTimeout(() => location.reload(), 2000);
    return;
  }

  if (timerEl) {
    const minutes = Math.floor(diff / 60);
    const seconds = diff % 60;
    timerEl.textContent = `${minutes}:${seconds.toString().padStart(2, '0')}`;
  }
}

updateTimer();
setInterval(updateTimer, 1000);
</script>
<?php endif; ?>
</body>
</html>
